mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path  (current_mod_path.."/Textures/ZUIKAKU")
mount_vfs_liveries_path (current_mod_path.."/Liveries")

GT = {};
dofile(current_mod_path..'/ZUIKAKURunwaysAndRoutes.lua')
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "ZUIKAKU"
GT.visual.shape_dstr = ""
GT.animation_arguments.radar1_rotation = 11;
GT.radar1_period = 3;
GT.life = 6800;
GT.mass = 25675e+007;
GT.max_velocity = 17.5;
GT.race_velocity = 17.5;
GT.economy_velocity = 17.5;
GT.economy_distance = 9.3312e+007;
GT.race_distance = 30.778e+006;
GT.shipLength = 257.5;
GT.Width = 38.68;
GT.Height = 39.25;
GT.Length = 257.11;
GT.DeckLevel = 14.14;
GT.X_nose = 123.67	-- ͎̔g̈ʒu;
GT.X_tail = -124.53	-- ͔̔g̈ʒu;
GT.Tail_Width = 20	-- ͔̔g̕;
GT.Gamma_max = 0.35;
GT.Om = 0.05;
GT.speedup = 0.567114;
GT.R_min = 40;
GT.distFindObstacles = 90;
GT.TACAN = true;
GT.numParking = 16;  -- edited by baco30, was 4
GT.Plane_Num_ = 72;
GT.Helicopter_Num_ = 0;
GT.animation_arguments.water_propeller = -1;
GT.airWeaponDist = 7000;   -- edited by baco30, was 3000
GT.airFindDist = 15000;   -- edited by baco30, was 5000
GT.animation_arguments.arresting_wires = {101, 102, 103, 104, 105, 106};
GT.ArrestingGears = {
	{
		Left = {	pos = {-74.13,   14.40,  -11.64} },
		Right = {	pos = {-74.13,   14.40,   9.74} }
	},
	{
		Left = {	pos = {-63.79,   14.40,  -11.65} },
		Right = {	pos = {-63.79,   14.40,   9.95} }
	},
	{
		Left = {	pos = {-51.97,   14.40,  -11.59} },
		Right = {	pos = {-51.97,   14.40,   10.23} }
	},
	{
		Left = {	pos = {-40.29,   14.40,  -11.68} },
		Right = {	pos = {-40.29,   14.40,   10.41} }
	},
	{
		Left = {	pos = {-28.66,   14.40, -11.7} },
		Right = {	pos = {-28.66,   14.40,  10.77} }
	},
	{
		Left = {	pos = {-3.63,   14.40, -11.7} },
		Right = {	pos = {-3.63,   14.40,  10.62} }
	},
--	{
--		Left = {	pos = {9.96,   14.40, -11.74} },
--		Right = {	pos = {9.96,   14.40,  10.71} }
--	},
--	{
--		Left = {	pos = {51.38,   14.40, -11.07} },
--		Right = {	pos = {51.38,   14.40,  10.68} }
--	},
}
GT.ArrestingGears.ArrestingGearsNumber = #GT.ArrestingGears
GT.exhaust = 
{
	[1] = { size = 0.5 , pos = {5.797, 10.982, 18.044} },
	[2] = { size = 0.5 , pos = {-5.752, 10.982, 18.044} },
}

GT.LSOView = {cockpit = "empty", position = {--[[connector = "",]] offset = {-83.5, 14.6, -14.6, -179.5, 5.0}}}
GT.OLS = {Type = GT_t.OLS_TYPE.Luna, MeatBallArg = 100}

GT.Landing_Point = {-52.0, 14.14, 0.0}

-- weapon systems

GT.WS = {}
GT.WS.maxTargetDetectionRange = 30000;
GT.WS.radar_type = 104
GT.WS.searchRadarMaxElevation = math.rad(50);


-------------------------------------------------------------------------
--- 25mm @e
-------------------------------------------------------------------------

GT_t.WS_t.Mgun_25mm = {name = "25mm Machine gun", display_name = _("25mm Machine gun")};
GT_t.WS_t.Mgun_25mm.angles = {
                    {math.rad(90), math.rad(-90), math.rad(-10), math.rad(80)},
                    };
GT_t.WS_t.Mgun_25mm.omegaY = math.rad(115)
GT_t.WS_t.Mgun_25mm.omegaZ = math.rad(116)
GT_t.WS_t.Mgun_25mm.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.Mgun_25mm.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.Mgun_25mm.reference_angle_Z = 0
GT_t.WS_t.Mgun_25mm.distanceMax = 2500
GT_t.WS_t.Mgun_25mm.max_trg_alt = 3000
GT_t.WS_t.Mgun_25mm.LN = {}
GT_t.WS_t.Mgun_25mm.LN[1] = {}
set_recursive_metatable(GT_t.WS_t.Mgun_25mm.LN[1], GT_t.LN_t.automatic_gun_25mm);
GT_t.WS_t.Mgun_25mm.LN[1].name = "25mm Machine gun"
GT_t.WS_t.Mgun_25mm.LN[1].display_name = _("25mm Machine gun")
GT_t.WS_t.Mgun_25mm.LN[1].PL[1].shot_delay = 15/100;
GT_t.WS_t.Mgun_25mm.LN[1].PL[2].shot_delay = 15/100;


--- O

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].center = 'CENTER_MGUN_F_1'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 20
GT.WS[ws].drawArgument2 = 21
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_F_11'},
	{connector_name = 'POINT_MGUN_F_12'},
	{connector_name = 'POINT_MGUN_F_13'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].center = 'CENTER_MGUN_F_2'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 22
GT.WS[ws].drawArgument2 = 23
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_F_21'},
	{connector_name = 'POINT_MGUN_F_22'},
	{connector_name = 'POINT_MGUN_F_23'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].center = 'CENTER_MGUN_F_3'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 24
GT.WS[ws].drawArgument2 = 25
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_F_31'},
	{connector_name = 'POINT_MGUN_F_32'},
	{connector_name = 'POINT_MGUN_F_33'}
};


--- 

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 2;
GT.WS[ws].center = 'CENTER_MGUN_T_1'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 26
GT.WS[ws].drawArgument2 = 27
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_T_11'},
	{connector_name = 'POINT_MGUN_T_12'},
	{connector_name = 'POINT_MGUN_T_13'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 2;
GT.WS[ws].center = 'CENTER_MGUN_T_2'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 28
GT.WS[ws].drawArgument2 = 29
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_T_21'},
	{connector_name = 'POINT_MGUN_T_22'},
	{connector_name = 'POINT_MGUN_T_23'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 2;
GT.WS[ws].center = 'CENTER_MGUN_T_3'
GT.WS[ws].angles = {{math.rad(100), math.rad(-100), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 30
GT.WS[ws].drawArgument2 = 31
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_T_31'},
	{connector_name = 'POINT_MGUN_T_32'},
	{connector_name = 'POINT_MGUN_T_33'}
};


--- 

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_1'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 32
GT.WS[ws].drawArgument2 = 33
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_11'},
	{connector_name = 'POINT_MGUN_L_12'},
	{connector_name = 'POINT_MGUN_L_13'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_2'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 34
GT.WS[ws].drawArgument2 = 35
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_21'},
	{connector_name = 'POINT_MGUN_L_22'},
	{connector_name = 'POINT_MGUN_L_23'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_3'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 36
GT.WS[ws].drawArgument2 = 37
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_31'},
	{connector_name = 'POINT_MGUN_L_32'},
	{connector_name = 'POINT_MGUN_L_33'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_4'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 38
GT.WS[ws].drawArgument2 = 39
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_41'},
	{connector_name = 'POINT_MGUN_L_42'},
	{connector_name = 'POINT_MGUN_L_43'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_5'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 40
GT.WS[ws].drawArgument2 = 41
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_51'},
	{connector_name = 'POINT_MGUN_L_52'},
	{connector_name = 'POINT_MGUN_L_53'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_MGUN_L_6'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 42
GT.WS[ws].drawArgument2 = 43
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_L_61'},
	{connector_name = 'POINT_MGUN_L_62'},
	{connector_name = 'POINT_MGUN_L_63'}
};


--- E

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_1'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 44
GT.WS[ws].drawArgument2 = 45
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_11'},
	{connector_name = 'POINT_MGUN_R_12'},
	{connector_name = 'POINT_MGUN_R_13'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_2'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 46
GT.WS[ws].drawArgument2 = 47
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_21'},
	{connector_name = 'POINT_MGUN_R_22'},
	{connector_name = 'POINT_MGUN_R_23'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_3'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 48
GT.WS[ws].drawArgument2 = 49
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_31'},
	{connector_name = 'POINT_MGUN_R_32'},
	{connector_name = 'POINT_MGUN_R_33'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_4'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 50
GT.WS[ws].drawArgument2 = 51
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_41'},
	{connector_name = 'POINT_MGUN_R_42'},
	{connector_name = 'POINT_MGUN_R_43'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_5'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 52
GT.WS[ws].drawArgument2 = 53
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_51'},
	{connector_name = 'POINT_MGUN_R_52'},
	{connector_name = 'POINT_MGUN_R_53'}
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Mgun_25mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_MGUN_R_6'
GT.WS[ws].angles = {{math.rad(80), math.rad(-80), math.rad(-10), math.rad(80)}};
GT.WS[ws].drawArgument1 = 54
GT.WS[ws].drawArgument2 = 55
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_MGUN_R_61'},
	{connector_name = 'POINT_MGUN_R_62'},
	{connector_name = 'POINT_MGUN_R_63'}
};


-------------------------------------------------------------------------
--- 12.7cm pC
-------------------------------------------------------------------------

declare_weapon({category = CAT_SHELLS, name = "MK3_127", user_name = _("127mm HE"),
	model_name = "pula",
	mass = 23.0,
	explosive = 23.0,
	v0 = 720.0,
	Dv0 = 0.0023,
	Da0 = 0.0005,
	Da1 = 0.0002,
	life_time = 8.0,
	caliber = 127.0,
	s = 0.0,
	j = 0.0,
	l = 0.0,
	charTime = 0,
	cx = {0.0, 0.52, 0.67, 0.14, 1.76},
	k1 = 7.6e-10,
	tracer_off = 100,
	scale_tracer = 0,
	rotation_freq = 0,
	cartridge = 0,
})


GT_t.WS_t.Flak_127mm = {};
set_recursive_metatable(GT_t.WS_t.Flak_127mm, GT_t.WS_t.ship_FMC5 )
GT_t.WS_t.Flak_127mm.angles = {
					{math.rad(80), math.rad(-80), math.rad(-8), math.rad(80)},
					};
GT_t.WS_t.Flak_127mm.LN[1].type = 3
GT_t.WS_t.Flak_127mm.LN[1].distanceMin = 10
GT_t.WS_t.Flak_127mm.LN[1].distanceMax = 14622
GT_t.WS_t.Flak_127mm.LN[1].max_trg_alt = 7500
GT_t.WS_t.Flak_127mm.LN[1].reactionTime = 0.1
GT_t.WS_t.Flak_127mm.LN[1].PL[1].shell_name = {"MK3_127"};
GT_t.WS_t.Flak_127mm.LN[1].PL[1].shell_display_name = "127mm HE";


--- 

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_FLAK_L_1'
GT.WS[ws].drawArgument1 = 56
GT.WS[ws].drawArgument2 = 57
GT.WS[ws].LN[1].fireAnimationArgument = 110;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_L_11'},
	{connector_name = 'POINT_FLAK_L_12'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_FLAK_L_2'
GT.WS[ws].drawArgument1 = 58
GT.WS[ws].drawArgument2 = 59
GT.WS[ws].LN[1].fireAnimationArgument = 111;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_L_21'},
	{connector_name = 'POINT_FLAK_L_22'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_FLAK_L_3'
GT.WS[ws].drawArgument1 = 70
GT.WS[ws].drawArgument2 = 71
GT.WS[ws].LN[1].fireAnimationArgument = 112;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_L_31'},
	{connector_name = 'POINT_FLAK_L_32'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 3;
GT.WS[ws].center = 'CENTER_FLAK_L_4'
GT.WS[ws].drawArgument1 = 72
GT.WS[ws].drawArgument2 = 73
GT.WS[ws].LN[1].fireAnimationArgument = 113;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_L_41'},
	{connector_name = 'POINT_FLAK_L_42'},
};


--- E

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_FLAK_R_1'
GT.WS[ws].drawArgument1 = 74
GT.WS[ws].drawArgument2 = 75
GT.WS[ws].LN[1].fireAnimationArgument = 114;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_R_11'},
	{connector_name = 'POINT_FLAK_R_12'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_FLAK_R_2'
GT.WS[ws].drawArgument1 = 76
GT.WS[ws].drawArgument2 = 77
GT.WS[ws].LN[1].fireAnimationArgument = 115;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_R_21'},
	{connector_name = 'POINT_FLAK_R_22'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_FLAK_R_3'
GT.WS[ws].drawArgument1 = 78
GT.WS[ws].drawArgument2 = 79
GT.WS[ws].LN[1].fireAnimationArgument = 116;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_R_31'},
	{connector_name = 'POINT_FLAK_R_32'},
};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Flak_127mm)
GT.WS[ws].board = 4;
GT.WS[ws].center = 'CENTER_FLAK_R_4'
GT.WS[ws].drawArgument1 = 80
GT.WS[ws].drawArgument2 = 81
GT.WS[ws].LN[1].fireAnimationArgument = 117;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_FLAK_R_41'},
	{connector_name = 'POINT_FLAK_R_42'},
};
--


-------------------------------------------------------------------------
--- iC
-------------------------------------------------------------------------

dofile('Scripts/Database/Weapons/warheads.lua')

ROCKET_4 = {
	category		= CAT_MISSILES,
	name			= "Type4 Rocket", 
	user_name		= _("Type4 Rocket"),
	wsTypeOfWeapon	= {wsType_Weapon, wsType_Missile, wsType_Rocket, WSTYPE_PLACEHOLDER},
	Escort = 0,
	Head_Type = 0,
	sigma = {3, 3, 3},
	M = 22.0,
	H_max = 2600.0,
	H_min = 1.0,
	Diam = 120.0,
	Cx_pil = 1,
	D_max = 5000.0,
	D_min = 200.0,
	Head_Form = 1,
	Life_Time = 8.0,
	Nr_max = 18,
	v_min = 70.0,
	v_mid = 300.0,
	Mach_max = 1.9,
	t_b = 0.0,
	t_acc = 5.0,
	t_marsh = 5.0,
	Range_max = 4800.0,
	H_min_t = 10.0,
	Fi_start = math.rad(1),
	Fi_rak = 3.14152,
	Fi_excort = 0.7,
	Fi_search = 99.9,
	OmViz_max = 99.9,
	warhead = HE_penetrating_warhead(0.3),
	exhaust = { 1, 1, 1, 1 },
	X_back = -0.781,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.0044,
	KillDistance = 10.0,
	SeekerSensivityDistance = 10000,
	ccm_k0 = 0.0,
	SeekerCooled = true,
	shape_table_data =
	{
		{
			name  = "HVAR_rocket";
			file  = "HVAR_rocket";
			life  = 1;
			fire  = { 0, 1};
			username = "Type4 Rocket";
			index	= WSTYPE_PLACEHOLDER,
		},
	},
}
declare_weapon(ROCKET_4)


GT_t.WS_t.Rocket_120mm = {name = "120mm Rocket", display_name = _("120mm Rocket")};
GT_t.WS_t.Rocket_120mm.angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT_t.WS_t.Rocket_120mm.omegaY = math.rad(115)
GT_t.WS_t.Rocket_120mm.omegaZ = math.rad(116)
GT_t.WS_t.Rocket_120mm.pidY = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.Rocket_120mm.pidZ = {p=300, i = 0.05, d = 10.0, inn = 1000};
GT_t.WS_t.Rocket_120mm.reference_angle_Z = 0
GT_t.WS_t.Rocket_120mm.stabilizer = false; --true;
GT_t.WS_t.Rocket_120mm.laser = false; --true;
GT_t.WS_t.Rocket_120mm.LN = {}
GT_t.WS_t.Rocket_120mm.LN[1] = {}
GT_t.WS_t.Rocket_120mm.LN[1].type = 4
GT_t.WS_t.Rocket_120mm.LN[1].barrels_reload_type = 3;
GT_t.WS_t.Rocket_120mm.LN[1].distanceMin = 200
GT_t.WS_t.Rocket_120mm.LN[1].distanceMax = 4500
GT_t.WS_t.Rocket_120mm.LN[1].reactionTime = 2;
GT_t.WS_t.Rocket_120mm.LN[1].launch_delay = 1;
GT_t.WS_t.Rocket_120mm.LN[1].reflection_limit = 0.22
GT_t.WS_t.Rocket_120mm.LN[1].ECM_K = -1
GT_t.WS_t.Rocket_120mm.LN[1].sensor = {}
set_recursive_metatable(GT_t.WS_t.Rocket_120mm.LN[1].sensor, GT_t.WSN_t[0])
GT_t.WS_t.Rocket_120mm.LN[1].PL = {}
GT_t.WS_t.Rocket_120mm.LN[1].PL[1] = {}
GT_t.WS_t.Rocket_120mm.LN[1].PL[1].ammo_capacity = 4  --- was 30 
GT_t.WS_t.Rocket_120mm.LN[1].PL[1].reload_time = 120;
GT_t.WS_t.Rocket_120mm.LN[1].PL[1].type_ammunition = ROCKET_4.wsTypeOfWeapon
GT_t.WS_t.Rocket_120mm.LN[1].PL[1].name_ammunition = "ROCKET_4"
GT_t.WS_t.Rocket_120mm.LN[1].PL[1].shot_delay = 0.01;
GT_t.WS_t.Rocket_120mm.LN[1].BR = {{ pos = {1, 0, 0}}}


--- 

local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_L_1'
GT.WS[ws].board = 3;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 82;
GT.WS[ws].drawArgument2 = 83;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_L_101'},
	{connector_name = 'POINT_ROCKET_L_102'},
	{connector_name = 'POINT_ROCKET_L_103'},
	{connector_name = 'POINT_ROCKET_L_104'},
	{connector_name = 'POINT_ROCKET_L_105'},
	{connector_name = 'POINT_ROCKET_L_106'},
	{connector_name = 'POINT_ROCKET_L_107'},
	{connector_name = 'POINT_ROCKET_L_108'},
	{connector_name = 'POINT_ROCKET_L_109'},
	{connector_name = 'POINT_ROCKET_L_110'},
	{connector_name = 'POINT_ROCKET_L_111'},
	{connector_name = 'POINT_ROCKET_L_112'},
	{connector_name = 'POINT_ROCKET_L_113'},
	{connector_name = 'POINT_ROCKET_L_114'},
	{connector_name = 'POINT_ROCKET_L_115'},
	{connector_name = 'POINT_ROCKET_L_116'},
	{connector_name = 'POINT_ROCKET_L_117'},
	{connector_name = 'POINT_ROCKET_L_118'},
	{connector_name = 'POINT_ROCKET_L_119'},
	{connector_name = 'POINT_ROCKET_L_120'},
	{connector_name = 'POINT_ROCKET_L_121'},
	{connector_name = 'POINT_ROCKET_L_122'},
	{connector_name = 'POINT_ROCKET_L_123'},
	{connector_name = 'POINT_ROCKET_L_124'},
	{connector_name = 'POINT_ROCKET_L_125'},
	{connector_name = 'POINT_ROCKET_L_126'},
	{connector_name = 'POINT_ROCKET_L_127'},
	{connector_name = 'POINT_ROCKET_L_128'},
	{connector_name = 'POINT_ROCKET_L_129'},
	{connector_name = 'POINT_ROCKET_L_130'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_L_2'
GT.WS[ws].board = 3;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 84;
GT.WS[ws].drawArgument2 = 85;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_L_201'},
	{connector_name = 'POINT_ROCKET_L_202'},
	{connector_name = 'POINT_ROCKET_L_203'},
	{connector_name = 'POINT_ROCKET_L_204'},
	{connector_name = 'POINT_ROCKET_L_205'},
	{connector_name = 'POINT_ROCKET_L_206'},
	{connector_name = 'POINT_ROCKET_L_207'},
	{connector_name = 'POINT_ROCKET_L_208'},
	{connector_name = 'POINT_ROCKET_L_209'},
	{connector_name = 'POINT_ROCKET_L_210'},
	{connector_name = 'POINT_ROCKET_L_211'},
	{connector_name = 'POINT_ROCKET_L_212'},
	{connector_name = 'POINT_ROCKET_L_213'},
	{connector_name = 'POINT_ROCKET_L_214'},
	{connector_name = 'POINT_ROCKET_L_215'},
	{connector_name = 'POINT_ROCKET_L_216'},
	{connector_name = 'POINT_ROCKET_L_217'},
	{connector_name = 'POINT_ROCKET_L_218'},
	{connector_name = 'POINT_ROCKET_L_219'},
	{connector_name = 'POINT_ROCKET_L_220'},
	{connector_name = 'POINT_ROCKET_L_221'},
	{connector_name = 'POINT_ROCKET_L_222'},
	{connector_name = 'POINT_ROCKET_L_223'},
	{connector_name = 'POINT_ROCKET_L_224'},
	{connector_name = 'POINT_ROCKET_L_225'},
	{connector_name = 'POINT_ROCKET_L_226'},
	{connector_name = 'POINT_ROCKET_L_227'},
	{connector_name = 'POINT_ROCKET_L_228'},
	{connector_name = 'POINT_ROCKET_L_229'},
	{connector_name = 'POINT_ROCKET_L_230'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_L_3'
GT.WS[ws].board = 3;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 86;
GT.WS[ws].drawArgument2 = 87;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_L_301'},
	{connector_name = 'POINT_ROCKET_L_302'},
	{connector_name = 'POINT_ROCKET_L_303'},
	{connector_name = 'POINT_ROCKET_L_304'},
	{connector_name = 'POINT_ROCKET_L_305'},
	{connector_name = 'POINT_ROCKET_L_306'},
	{connector_name = 'POINT_ROCKET_L_307'},
	{connector_name = 'POINT_ROCKET_L_308'},
	{connector_name = 'POINT_ROCKET_L_309'},
	{connector_name = 'POINT_ROCKET_L_310'},
	{connector_name = 'POINT_ROCKET_L_311'},
	{connector_name = 'POINT_ROCKET_L_312'},
	{connector_name = 'POINT_ROCKET_L_313'},
	{connector_name = 'POINT_ROCKET_L_314'},
	{connector_name = 'POINT_ROCKET_L_315'},
	{connector_name = 'POINT_ROCKET_L_316'},
	{connector_name = 'POINT_ROCKET_L_317'},
	{connector_name = 'POINT_ROCKET_L_318'},
	{connector_name = 'POINT_ROCKET_L_319'},
	{connector_name = 'POINT_ROCKET_L_320'},
	{connector_name = 'POINT_ROCKET_L_321'},
	{connector_name = 'POINT_ROCKET_L_322'},
	{connector_name = 'POINT_ROCKET_L_323'},
	{connector_name = 'POINT_ROCKET_L_324'},
	{connector_name = 'POINT_ROCKET_L_325'},
	{connector_name = 'POINT_ROCKET_L_326'},
	{connector_name = 'POINT_ROCKET_L_327'},
	{connector_name = 'POINT_ROCKET_L_328'},
	{connector_name = 'POINT_ROCKET_L_329'},
	{connector_name = 'POINT_ROCKET_L_330'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_L_4'
GT.WS[ws].board = 3;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 88;
GT.WS[ws].drawArgument2 = 89;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_L_401'},
	{connector_name = 'POINT_ROCKET_L_402'},
	{connector_name = 'POINT_ROCKET_L_403'},
	{connector_name = 'POINT_ROCKET_L_404'},
	{connector_name = 'POINT_ROCKET_L_405'},
	{connector_name = 'POINT_ROCKET_L_406'},
	{connector_name = 'POINT_ROCKET_L_407'},
	{connector_name = 'POINT_ROCKET_L_408'},
	{connector_name = 'POINT_ROCKET_L_409'},
	{connector_name = 'POINT_ROCKET_L_410'},
	{connector_name = 'POINT_ROCKET_L_411'},
	{connector_name = 'POINT_ROCKET_L_412'},
	{connector_name = 'POINT_ROCKET_L_413'},
	{connector_name = 'POINT_ROCKET_L_414'},
	{connector_name = 'POINT_ROCKET_L_415'},
	{connector_name = 'POINT_ROCKET_L_416'},
	{connector_name = 'POINT_ROCKET_L_417'},
	{connector_name = 'POINT_ROCKET_L_418'},
	{connector_name = 'POINT_ROCKET_L_419'},
	{connector_name = 'POINT_ROCKET_L_420'},
	{connector_name = 'POINT_ROCKET_L_421'},
	{connector_name = 'POINT_ROCKET_L_422'},
	{connector_name = 'POINT_ROCKET_L_423'},
	{connector_name = 'POINT_ROCKET_L_424'},
	{connector_name = 'POINT_ROCKET_L_425'},
	{connector_name = 'POINT_ROCKET_L_426'},
	{connector_name = 'POINT_ROCKET_L_427'},
	{connector_name = 'POINT_ROCKET_L_428'},
	{connector_name = 'POINT_ROCKET_L_429'},
	{connector_name = 'POINT_ROCKET_L_430'},
};


--- E

local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_R_1'
GT.WS[ws].board = 4;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 90;
GT.WS[ws].drawArgument2 = 91;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_R_101'},
	{connector_name = 'POINT_ROCKET_R_102'},
	{connector_name = 'POINT_ROCKET_R_103'},
	{connector_name = 'POINT_ROCKET_R_104'},
	{connector_name = 'POINT_ROCKET_R_105'},
	{connector_name = 'POINT_ROCKET_R_106'},
	{connector_name = 'POINT_ROCKET_R_107'},
	{connector_name = 'POINT_ROCKET_R_108'},
	{connector_name = 'POINT_ROCKET_R_109'},
	{connector_name = 'POINT_ROCKET_R_110'},
	{connector_name = 'POINT_ROCKET_R_111'},
	{connector_name = 'POINT_ROCKET_R_112'},
	{connector_name = 'POINT_ROCKET_R_113'},
	{connector_name = 'POINT_ROCKET_R_114'},
	{connector_name = 'POINT_ROCKET_R_115'},
	{connector_name = 'POINT_ROCKET_R_116'},
	{connector_name = 'POINT_ROCKET_R_117'},
	{connector_name = 'POINT_ROCKET_R_118'},
	{connector_name = 'POINT_ROCKET_R_119'},
	{connector_name = 'POINT_ROCKET_R_120'},
	{connector_name = 'POINT_ROCKET_R_121'},
	{connector_name = 'POINT_ROCKET_R_122'},
	{connector_name = 'POINT_ROCKET_R_123'},
	{connector_name = 'POINT_ROCKET_R_124'},
	{connector_name = 'POINT_ROCKET_R_125'},
	{connector_name = 'POINT_ROCKET_R_126'},
	{connector_name = 'POINT_ROCKET_R_127'},
	{connector_name = 'POINT_ROCKET_R_128'},
	{connector_name = 'POINT_ROCKET_R_129'},
	{connector_name = 'POINT_ROCKET_R_130'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_R_2'
GT.WS[ws].board = 4;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 92;
GT.WS[ws].drawArgument2 = 93;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_R_201'},
	{connector_name = 'POINT_ROCKET_R_202'},
	{connector_name = 'POINT_ROCKET_R_203'},
	{connector_name = 'POINT_ROCKET_R_204'},
	{connector_name = 'POINT_ROCKET_R_205'},
	{connector_name = 'POINT_ROCKET_R_206'},
	{connector_name = 'POINT_ROCKET_R_207'},
	{connector_name = 'POINT_ROCKET_R_208'},
	{connector_name = 'POINT_ROCKET_R_209'},
	{connector_name = 'POINT_ROCKET_R_210'},
	{connector_name = 'POINT_ROCKET_R_211'},
	{connector_name = 'POINT_ROCKET_R_212'},
	{connector_name = 'POINT_ROCKET_R_213'},
	{connector_name = 'POINT_ROCKET_R_214'},
	{connector_name = 'POINT_ROCKET_R_215'},
	{connector_name = 'POINT_ROCKET_R_216'},
	{connector_name = 'POINT_ROCKET_R_217'},
	{connector_name = 'POINT_ROCKET_R_218'},
	{connector_name = 'POINT_ROCKET_R_219'},
	{connector_name = 'POINT_ROCKET_R_220'},
	{connector_name = 'POINT_ROCKET_R_221'},
	{connector_name = 'POINT_ROCKET_R_222'},
	{connector_name = 'POINT_ROCKET_R_223'},
	{connector_name = 'POINT_ROCKET_R_224'},
	{connector_name = 'POINT_ROCKET_R_225'},
	{connector_name = 'POINT_ROCKET_R_226'},
	{connector_name = 'POINT_ROCKET_R_227'},
	{connector_name = 'POINT_ROCKET_R_228'},
	{connector_name = 'POINT_ROCKET_R_229'},
	{connector_name = 'POINT_ROCKET_R_230'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_R_3'
GT.WS[ws].board = 4;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 94;
GT.WS[ws].drawArgument2 = 95;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_R_301'},
	{connector_name = 'POINT_ROCKET_R_302'},
	{connector_name = 'POINT_ROCKET_R_303'},
	{connector_name = 'POINT_ROCKET_R_304'},
	{connector_name = 'POINT_ROCKET_R_305'},
	{connector_name = 'POINT_ROCKET_R_306'},
	{connector_name = 'POINT_ROCKET_R_307'},
	{connector_name = 'POINT_ROCKET_R_308'},
	{connector_name = 'POINT_ROCKET_R_309'},
	{connector_name = 'POINT_ROCKET_R_310'},
	{connector_name = 'POINT_ROCKET_R_311'},
	{connector_name = 'POINT_ROCKET_R_312'},
	{connector_name = 'POINT_ROCKET_R_313'},
	{connector_name = 'POINT_ROCKET_R_314'},
	{connector_name = 'POINT_ROCKET_R_315'},
	{connector_name = 'POINT_ROCKET_R_316'},
	{connector_name = 'POINT_ROCKET_R_317'},
	{connector_name = 'POINT_ROCKET_R_318'},
	{connector_name = 'POINT_ROCKET_R_319'},
	{connector_name = 'POINT_ROCKET_R_320'},
	{connector_name = 'POINT_ROCKET_R_321'},
	{connector_name = 'POINT_ROCKET_R_322'},
	{connector_name = 'POINT_ROCKET_R_323'},
	{connector_name = 'POINT_ROCKET_R_324'},
	{connector_name = 'POINT_ROCKET_R_325'},
	{connector_name = 'POINT_ROCKET_R_326'},
	{connector_name = 'POINT_ROCKET_R_327'},
	{connector_name = 'POINT_ROCKET_R_328'},
	{connector_name = 'POINT_ROCKET_R_329'},
	{connector_name = 'POINT_ROCKET_R_330'},
};


local ws = GT_t.inc_ws();
GT.WS[ws] = {};
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.Rocket_120mm)
GT.WS[ws].center = 'CENTER_ROCKET_R_4'
GT.WS[ws].board = 4;
GT.WS[ws].angles = {{math.rad(70), math.rad(-70), math.rad(0), math.rad(70)}};
GT.WS[ws].drawArgument1 = 96;
GT.WS[ws].drawArgument2 = 97;
GT.WS[ws].LN[1].BR = {
	{connector_name = 'POINT_ROCKET_R_401'},
	{connector_name = 'POINT_ROCKET_R_402'},
	{connector_name = 'POINT_ROCKET_R_403'},
	{connector_name = 'POINT_ROCKET_R_404'},
	{connector_name = 'POINT_ROCKET_R_405'},
	{connector_name = 'POINT_ROCKET_R_406'},
	{connector_name = 'POINT_ROCKET_R_407'},
	{connector_name = 'POINT_ROCKET_R_408'},
	{connector_name = 'POINT_ROCKET_R_409'},
	{connector_name = 'POINT_ROCKET_R_410'},
	{connector_name = 'POINT_ROCKET_R_411'},
	{connector_name = 'POINT_ROCKET_R_412'},
	{connector_name = 'POINT_ROCKET_R_413'},
	{connector_name = 'POINT_ROCKET_R_414'},
	{connector_name = 'POINT_ROCKET_R_415'},
	{connector_name = 'POINT_ROCKET_R_416'},
	{connector_name = 'POINT_ROCKET_R_417'},
	{connector_name = 'POINT_ROCKET_R_418'},
	{connector_name = 'POINT_ROCKET_R_419'},
	{connector_name = 'POINT_ROCKET_R_420'},
	{connector_name = 'POINT_ROCKET_R_421'},
	{connector_name = 'POINT_ROCKET_R_422'},
	{connector_name = 'POINT_ROCKET_R_423'},
	{connector_name = 'POINT_ROCKET_R_424'},
	{connector_name = 'POINT_ROCKET_R_425'},
	{connector_name = 'POINT_ROCKET_R_426'},
	{connector_name = 'POINT_ROCKET_R_427'},
	{connector_name = 'POINT_ROCKET_R_428'},
	{connector_name = 'POINT_ROCKET_R_429'},
	{connector_name = 'POINT_ROCKET_R_430'},
};


GT.Name = "ZUIKAKU"
GT.DisplayName = _("ZUIKAKU")
GT.Rate = 5500.000000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV"},
                RADAR = {
                    "seasparrow tr",
                    "carrier search radar",
                },
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="yes";
GT.mapclasskey = "P0091000065";
GT.attribute = {wsType_Navy, wsType_Ship, wsType_AirCarrier,
				"Aircraft Carriers",
				"Arresting Gear",
--				"catapult",
				"ski_jump",
				"RADAR_BAND1_FOR_ARM",
				"RADAR_BAND2_FOR_ARM",
				};
GT.Categories = {
					{name = "AircraftCarrier"},
					{name = "AircraftCarrier With Catapult"},
					{name = "Armed Ship"}
				};

add_surface_unit(GT)
